 ; Ŀ
 ;   Naf - make cable names fit in tag boxes.                              
 ;   Copyright 1997, 2000, 2001, 2006 - 2009 by Rocket Software Ltd.       
 ;   Has to be able to find Puss.lsp.                                      
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Bowo - find the width of a block.                          
 ;   Argument: enam, a block insertion ename.                              
 ;   Calls Bent, so the file puss.lsp must be available.                   
 ;   Returns a distance.                                                   
 ; 
 (DEFUN BOWO (enam / blnam plist pta rhdis lhdis)
  (setq blnam (cdr (assoc 2 (entget enam))))
 ; Ŀ
 ;   Load the block corner point finder from Puss.lsp.                     
 ; 
  (if (not bent) (load "puss"))
 ; Ŀ
 ;   Get a list of the insertion point and block extents.                  
 ;   Bent returns a list: (insertion_point  x-max  x-min  y-max  y-min).   
 ; 
  (setq plist (bent blnam))
  (setq pta (car plist))
  (setq rhdis (+ (car pta) (cadr plist)))         ; right hand (+x) distance
  (setq lhdis (abs (+ (car pta) (caddr plist))))  ; left hand (-x) distance
 (+ rhdis lhdis))
 ; Ŀ
 ;   Bowo end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Cresh - squeeze or stretch attributes as required.         
 ;   Arguments: Enam, an attribute ename.                                  
 ;              Widd, the allowable actual width, without end gaps.        
 ;              Ideal, the ideal desired width scale factor.               
 ; 
 (DEFUN CRESH (enam widd ideal / entt realwd widscl prev41 widd scalfc)
  (setq entt (entget enam))
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
  (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
  (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ;   If the actual width is greater than the space then crush the          
 ;   attribute to fit.                                                     
 ; 
  (cond ((> realwd widd)
         (setq scalfc (/ widd realwd))
         (setq widscl (* widscl scalfc))
         (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Should see if the width scale is greater than ideal - if so then      
 ;   set it to ideal.                                                      
 ;   The previous condition checked to see if it was too wide, so don't    
 ;   have to do that here.                                                 
 ;   This should only happen if someone has done something odd.            
 ; 
        ((> widscl ideal)
         (entmod (subst (cons 41 ideal) prev41 entt)))
 ; Ŀ
 ;   See if the attribute is narrower than it should be.                   
 ;   If setting the width scale factor to the desired value would leave    
 ;   the attibute wider than the allowable space, then increase it just    
 ;   to fill the space.                                                    
 ; 
        ((< widscl ideal)
         (if (> (* realwd (/ ideal widscl)) widd)
                (progn
                     (setq scalfc (/ widd realwd))
                     (setq widscl (* widscl scalfc))
                     (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
                (entmod (subst (cons 41 ideal) prev41 entt)))))
 (princ))
 ; Ŀ
 ;   Cresh end.                                                            
 ; 

 ; Ŀ
 ;   Pixiz - find the pixel size in drawing units.                         
 ;   Takes no arguments, calls nothing, returns a distance.                
 ; 
 (DEFUN PIXIZ (/ vsize scsize)
  (setq vsize (getvar "viewsize"))       ; view height in dwg units
  (setq scsize (getvar "screensize"))    ; view width and height in pixels
 (/ vsize (cadr scsize)))                ; 1 pixel in dwg units
 ; Ŀ
 ;   Pixiz end.                                                            
 ; 

 ; Ŀ
 ;   Sq - make a grblock.                                                  
 ;   Arguments: Pul, the upper left point.                                 
 ;              Rad, the side length.                                      
 ;              Colo, the colour.                                          
 ;              Disa, the length of a pixel in drawing units.              
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN SQ (pul rad colo disa / reps pll)
  (setq pll (polar pul (* pi 1.5) rad))
 ; Ŀ
 ;   Grdraw the box.                                                       
 ; 
  (setq reps (fix (/ rad disa)))
  (repeat reps
          (grdraw pul pll colo)
          (setq pul (polar pul 0 disa))
          (setq pll (polar pll 0 disa)))
 (princ))
 ; Ŀ
 ;   Sq end.                                                               
 ; 

 ; Ŀ
 ;   Vad - draw a single invader.                                          
 ;   Arguments: Pa, a base point.                                          
 ;              Rad, the side length.                                      
 ;              Colo, the colour.                                          
 ;              Disa, the length of a pixel in drawing units.              
 ;              Vpat, the invader pattern.                                 
 ;              Vpat0, the existing invader pattern or nil.                
 ;              Offs, the offset of this pattern from the previous one     
 ;              in multiples of Rad.                                       
 ;   Calls Sq.                                                             
 ;   Returns Nothing.                                                      
 ; 
 (DEFUN VAD (pa rad colo disa vpat vpat0 offs / lisnum sub0 sub num pos pa0)
  (setq pa0 pa)
 ; Ŀ
 ;   Part 1: for each value in Vpat, if there isn't a matching one in      
 ;   Vpat0 (offset by -Offs) then draw it.                                 
 ; 
  (setq lisnum 0)
  (while (setq sub (nth lisnum vpat))
         (if vpat0 (setq sub0 (nth lisnum vpat0)))
         (setq lisnum (1+ lisnum))
         (setq num 0)
         (while (setq pos (nth num sub))
                (setq num (1+ num))
                (if (or (null sub0)
                        (not (member (+ pos offs) sub0)))
                    (sq (polar pa 0 (* rad pos)) rad colo disa)))
         (setq pa (polar pa (* pi 1.5) rad)))
 ; Ŀ
 ;   Part 2: for each value in Vpat0, if there isn't a matching one in     
 ;   Vpat (offset by Offs) then undraw it.                                 
 ; 
  (setq pa pa0)
  (setq lisnum 0)
  (while (and vpat0 (setq sub0 (nth lisnum vpat0)))
         (setq sub (nth lisnum vpat))
         (setq lisnum (1+ lisnum))
         (setq num 0)
         (while (setq pos (nth num sub0))
                (setq num (1+ num))
                (if (not (member (- pos offs) sub))
                    (sq (polar pa 0 (* rad (- pos offs))) rad colo disa)))
         (setq pa (polar pa (* pi 1.5) rad)))
 (princ))
 ; Ŀ
 ;   Vad.                                                                  
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of an attribute.                     
 ;   Takes one argument: the attribute entity data list.  Returns a width. 
 ; 
 (DEFUN WITS (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Naf.                                                                  
 ; 
 (DEFUN C:NAF (/ snapp *error* colo rad disa vad1a vad1b ss num enam esav
                                       bscal entt bxwid pa sub lisa1 lisa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Set up the invader stuff.                                             
 ; 
  (setq colo -1)
  (setq rad (/ (getvar "viewsize") 135))
  (setq disa (pixiz))                     ; drawing units per pixel
  (setq rad (* disa (fix (/ rad disa))))
 ; Ŀ
 ;   Invader patterns.                                                     
 ; 
  (setq vad1a '((4 5) (3 4 5 6) (2 3 4 5 6 7) (1 2 4 5 7 8)
                (1 2 3 4 5 6 7 8) (2 4 5 7) (1 8) (2 7)))
  (setq vad1b '((4 5) (3 4 5 6) (2 3 4 5 6 7) (1 2 4 5 7 8)
                (1 2 3 4 5 6 7 8) (3 6) (2 4 5 7) (1 3 6 8)))
 ; Ŀ
 ;   Get an ss of block inserts with attributes.                           
 ; 
  (setq ss (ssget '((0 . "insert") (66 . 1))))
 ; Ŀ
 ;   For each one...                                                       
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq esav enam)
         (setq num (1+ num))
 ; Ŀ
 ;   Find the space available in the block.                                
 ; 
         (setq bscal (cdr (assoc 41 (setq entt (entget enam)))))
         (setq bxwid (* bscal (bowo enam)))
         (setq bxwid (- bxwid (* bscal 3)))  ; allow for end gaps
         (setq pa (cdr (assoc 10 entt)))
 ; Ŀ
 ;   Adjust the attribute width.                                           
 ; 
         (setq enam (entnext enam))
         (cresh enam bxwid 1.0)
         (entupd esav)
 ; Ŀ
 ;   Draw an invader.                                                      
 ; 
         (setq pa0 pa)
         (vad pa rad colo disa vad1a nil 0)
         (command "delay" 84)
 ; Ŀ
 ;   Update the rest of the list.                                          
 ; 
         (setq num2 0)
         (while (and lisa (setq sub (nth num2 lisa)))
                (setq num2 (1+ num2))
                (setq pa (polar (car sub) 0 rad))
                (if (zerop (cadr sub))
                    (progn
                         (vad pa rad colo disa vad1a vad1b 1)
                         (setq lisa1 (cons (list pa 1) lisa1)))
                    (progn
                         (vad pa rad colo disa vad1b vad1a 1)
                         (setq lisa1 (cons (list pa 0) lisa1)))))
         (setq lisa (reverse lisa1))
         (setq lisa1 nil)
 ; Ŀ
 ;   Add the new invader to the list.                                      
 ; 
         (setq lisa (append lisa (list (list pa0 1)))))
 ; Ŀ
 ;   Erase all the invaders.                                               
 ; 
  (setq num2 0)
  (while (setq sub (nth num2 lisa))
         (setq num2 (1+ num2))
         (setq pa (car sub))
         (if (zerop (cadr sub))
             (vad pa rad colo disa vad1b nil 1)
             (vad pa rad colo disa vad1a nil 1)))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* ())
 (princ))